#include "SimilarityCompute.h"
#include "main.h"



SimilarityCompute::SimilarityCompute()
{

}

SimilarityCompute::~SimilarityCompute()
{
}

void SimilarityCompute::LoadHistgramDataSet(string pathToHist, int numOfImage, int codeBookSize)
{
	
	

	ifstream ifs(pathToHist.c_str());
	if(!ifs)
		std::cerr << "file open error" << std::endl;


	char ch[100];
	int tmp;

	for (int i = 0; i < numOfImage; i++) {
		ifs >> ch;
		vector<int> into_histgramDataSet;
		for (int j = 0; j < codeBookSize; j++) {

			ifs >> ch;
			tmp = atoi(ch);
			into_histgramDataSet.push_back(tmp);

		}

		histgramDataSet.push_back(into_histgramDataSet);
		//ifs >> ch;
	}

	return;
}

void SimilarityCompute::LoadHistgramInputs(string pathToHist, int numOfImage, int codeBookSize)
{
	
	

	ifstream ifs(pathToHist.c_str());
	if(!ifs)
		std::cerr << "file open error" << std::endl;


	char ch[100];
	int tmp;

	for (int i = 0; i < numOfImage; i++) {
		ifs >> ch;
		vector<int> into_histgramInputs;
		for (int j = 0; j < codeBookSize; j++) {

			ifs >> ch;
			tmp = atoi(ch);
			into_histgramInputs.push_back(tmp);

		}

		histgramInputs.push_back(into_histgramInputs);
		//ifs >> ch;
	}

	return;
}

void SimilarityCompute::SaveHistgramDataSet(string pathToSave)
{

	std::ofstream ofs(pathToSave);

	for (int i = 0; i < histgramDataSet.size(); i++) {

		ofs << "[" << i + 1 << "] ";

		for (int j = 0; j < histgramDataSet[i].size(); j++) {
			
			ofs << histgramDataSet[i][j] << " ";

		}
		ofs << endl;
	}

	return;
}

double SimilarityCompute::ComputeHistgramSimilarity(vector<int> hist1, vector<int> hist2)
{

	if (hist1.size() != hist2.size()) return -1.0;


	int sum1 = 0;
	int sum2 = 0;
	
	for (int i = 0; i < hist1.size(); i++) {
		sum2 += hist1[i];

		if (hist1[i] < hist2[i]) {
			sum1 += hist1[i];
		} else {
			sum1 += hist2[i];
		}
	}


	//return sum1 / sum2;
	//cout << "sum1 : " << sum1 << "sum2: " << sum2 << endl;
	return sum1;

}

int SimilarityCompute::JudgeForestOrNot(vector<int> InputHist)
{

	map<double, int> similarityMap;

	
	for (int i = 0; i < histgramDataSet.size(); i++) {
		double similarity = ComputeHistgramSimilarity(InputHist, histgramDataSet[i]);

		similarityMap.insert(map<double, int>::value_type(similarity, i));
	}

	map<double, int>::reverse_iterator it = similarityMap.rbegin();

	int ForestNum = 0;
	int NotForestNum = 0;
	for (int j = 0; j < NUM; j++) {


		cout << (*it).first << ":" << (*it).second << endl;

		if ((*it).second > HALF)
			ForestNum++;
		else
			NotForestNum++;



		++it;
	}

	if (ForestNum > NotForestNum) {
		return FOREST;
	} else if (ForestNum < NotForestNum){
		return NOT_FOREST;
	} else {

	return UNKNOWN;
	}
}

void SimilarityCompute::IterativeJudge()
{

	std::ofstream ofs("result.txt");


	for (int i = 0; i < histgramInputs.size(); i++) {
		ofs << "Image[" << i + 1 << "]" << endl;
		int rt = JudgeForestOrNot(histgramInputs[i]);


		if (rt == FOREST) {
			ofs << "Image[" << i + 1 << "]͐XłD" << endl;
		} else if (rt == NOT_FOREST) {
			ofs << "Image[" << i + 1 << "]͎RłD" << endl;
		} else {
			ofs << "Image[" << i + 1 << "]͂킩܂D" << endl;
		}


	}
}